unit U_KJ_COST;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, BaseNormalForm, DBGridEhGrouping, ToolCtrlsEh, DBGridEhToolCtrls,
  DynVarsEh, wwDialog, wwrcdvw, DB, ADODB, DBClient, frxClass, frxDBSet, jpeg,
  StdCtrls, RzButton, RzPanel, Grids, Wwdbigrd, Wwdbgrid, RzTabs, Buttons,
  ExtCtrls, Mask, wwdbedit, EhLibVCL, GridsEh, DBAxisGridsEh, DBGridEh, wwdblook,
  wwdbdatetimepicker, ccBoxes, JoeChkDTPicker2, JoeChkEdit, Menus, Wwdotdot,
  Wwdbcomb;

type
  TFrm_KJ_COST = class(Tfrm_BaseNormalForm)
    Qry_MBDRQ: TDateTimeField;
    Qry_MKHBH: TStringField;
    Qry_MHBDW: TStringField;
    Qry_MHL: TBCDField;
    CDS_MKDR: TStringField;
    CDS_MKDRQ: TDateTimeField;
    CDS_MSHF: TBooleanField;
    CDS_MSHR: TStringField;
    CDS_MSHRQ: TDateTimeField;
    CDS_MREMARK: TStringField;
    CDS_MZZZZWWWW: TStringField;
    CDS_MBDRQ: TDateTimeField;
    CDS_MKHBH: TStringField;
    CDS_MHBDW: TStringField;
    CDS_MHL: TBCDField;
    Qry_DSH_DH: TStringField;
    Qry_DSH_XH: TIntegerField;
    Qry_DSH_ID: TIntegerField;
    Qry_DSCDH: TStringField;
    Qry_DCPBH: TStringField;
    Qry_DSHSL: TIntegerField;
    Qry_DCPDJ: TBCDField;
    Qry_DCPJE: TBCDField;
    Qry_DREMARK: TStringField;
    CDS_DSH_DH: TStringField;
    CDS_DSH_XH: TIntegerField;
    CDS_DSH_ID: TIntegerField;
    CDS_DSCDH: TStringField;
    CDS_DCPBH: TStringField;
    CDS_DSHSL: TIntegerField;
    CDS_DCPDJ: TBCDField;
    CDS_DCPJE: TBCDField;
    CDS_DREMARK: TStringField;
    Qry_D1SCDH: TStringField;
    Qry_D1SHSL: TIntegerField;
    Qry_D1CPDJ: TBCDField;
    Qry_D1CPJE: TBCDField;
    Qry_D1BJ_DH: TStringField;
    Qry_D1REMARK: TStringField;
    CDS_D1SCDH: TStringField;
    CDS_D1SHSL: TIntegerField;
    CDS_D1CPDJ: TBCDField;
    CDS_D1CPJE: TBCDField;
    CDS_D1BJ_DH: TStringField;
    CDS_D1REMARK: TStringField;
    Qry_D_DSBID: TIntegerField;
    Qry_D_DBJ_GXLB: TStringField;
    Qry_D_DBJ_GXXM: TStringField;
    Qry_D_DBJ_SL: TBCDField;
    Qry_D_DBJ_DJ: TBCDField;
    Qry_D_DBJ_JE: TBCDField;
    Qry_D_DCB_BL: TBCDField;
    Qry_D_DCB_SL: TBCDField;
    Qry_D_DCB_DJ: TBCDField;
    Qry_D_DCB_JE: TBCDField;
    Qry_D_DREMARK: TStringField;
    CDS_D_DBJ_GXLB: TStringField;
    CDS_D_DBJ_GXXM: TStringField;
    CDS_D_DBJ_SL: TBCDField;
    CDS_D_DBJ_DJ: TBCDField;
    CDS_D_DBJ_JE: TBCDField;
    CDS_D_DCB_BL: TBCDField;
    CDS_D_DCB_SL: TBCDField;
    CDS_D_DCB_DJ: TBCDField;
    CDS_D_DCB_JE: TBCDField;
    CDS_D_DREMARK: TStringField;
    Splitter2: TSplitter;
    G_Detail10: TDBGridEh;
    LCOM_BJ_DH: TwwDBLookupCombo;
    Qry_DHBDW: TStringField;
    Qry_DHL: TBCDField;
    CDS_DHBDW: TStringField;
    CDS_DHL: TBCDField;
    Label2: TLabel;
    wwDBDateTimePicker1: TwwDBDateTimePicker;
    CDS_ML_KHMC: TStringField;
    Label6: TLabel;
    Label4: TLabel;
    wwDBLookupCombo1: TwwDBLookupCombo;
    LCOM_KHMC: TwwDBLookupCombo;
    JCT_SHRQ: TJoeChkDTPicker2;
    Splitter3: TSplitter;
    JCE_SCDH: TJoeChkEdit;
    PM_SubD1: TPopupMenu;
    N1: TMenuItem;
    CDS_DL_HBMC: TStringField;
    CDS_D1C_CPDJ: TFloatField;
    CDS_D1BJ_XH: TIntegerField;
    Qry_MSP_KJ_COST_GetBJD: TADOQuery;
    Qry_MSP_KJ_COST_GetBJDBJ_DH: TStringField;
    Qry_MSP_KJ_COST_GetBJDBJ_XH: TIntegerField;
    Qry_MSP_KJ_COST_GetBJDLX: TIntegerField;
    Qry_MSP_KJ_COST_GetBJDCPMC: TStringField;
    Qry_MSP_KJ_COST_GetBJDBJSL: TIntegerField;
    Qry_MSP_KJ_COST_GetBJDSCDH: TStringField;
    Qry_MSP_KJ_COST_GetBJDFY_YS: TBCDField;
    Qry_MSP_KJ_COST_GetBJDFY_JG: TBCDField;
    Qry_MSP_KJ_COST_GetBJDFY_BF: TBCDField;
    Qry_MSP_KJ_COST_GetBJDFY_BZF: TBCDField;
    Qry_MSP_KJ_COST_GetBJDFY_YF: TBCDField;
    Qry_MSP_KJ_COST_GetBJDFY_QT: TBCDField;
    Qry_D1BJ_XH: TIntegerField;
    Qry_D1BJSL: TIntegerField;
    CDS_D1BJSL: TIntegerField;
    CDS_D1C_BL: TFloatField;
    N2: TMenuItem;
    N3: TMenuItem;
    Qry_D1BJ_LX: TIntegerField;
    CDS_D1BJ_LX: TIntegerField;
    Qry_D_DBJ_GXBH: TStringField;
    CDS_D_DBJ_GXBH: TStringField;
    Qry_MSP_KJ_COST_GetBJD_Detail: TADOQuery;
    CDS_D_DC_BJ_DJ: TFloatField;
    PM_Sub10: TPopupMenu;
    N4: TMenuItem;
    Qry_MXSE: TBCDField;
    CDS_MXSE: TBCDField;
    Label7: TLabel;
    ED_XSE: TwwDBEdit;
    CDS_DAgg_SUMCPJE: TAggregateField;
    CDS_D1Agg_SUMCPJE: TAggregateField;
    CDS_DAgg_SUMSHSL: TAggregateField;
    CDS_D1Agg_SUMSHSL: TAggregateField;
    N5: TMenuItem;
    N6: TMenuItem;
    Qry_MKHLX: TIntegerField;
    CDS_MKHLX: TIntegerField;
    LB_2: TLabel;
    CB_KHLX: TwwDBComboBox;
    procedure CDS_D_DNewRecord(DataSet: TDataSet);
    procedure CDS_MAfterScroll(DataSet: TDataSet);
    procedure FormCreate(Sender: TObject);
    procedure CDS_MNewRecord(DataSet: TDataSet);
    procedure Btn_QueryClick(Sender: TObject);
    procedure N1Click(Sender: TObject);
    procedure PM_SubD1Popup(Sender: TObject);
    procedure LCOM_BJ_DHCloseUp(Sender: TObject; LookupTable,
      FillTable: TDataSet; modified: Boolean);
    procedure CDS_D1CalcFields(DataSet: TDataSet);
    procedure LCOM_BJ_DHBeforeDropDown(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure LCOM_BJ_DHDropDown(Sender: TObject);
    procedure CDS_D1AfterScroll(DataSet: TDataSet);
    procedure G_Detail1CalcCellColors(Sender: TObject; Field: TField;
      State: TGridDrawState; Highlight: Boolean; AFont: TFont; ABrush: TBrush);
    procedure N3Click(Sender: TObject);
    procedure CDS_D_DCalcFields(DataSet: TDataSet);
    procedure N4Click(Sender: TObject);
    procedure PM_Sub10Popup(Sender: TObject);
    procedure DS_DDataChange(Sender: TObject; Field: TField);
    procedure DS_D1DataChange(Sender: TObject; Field: TField);
    procedure N6Click(Sender: TObject);
  private
    { Private declarations }
    procedure PriP_GetBJD;
    procedure PriP_GetBJD_Detail;
    procedure PriP_Calc_Detail;
  public
    { Public declarations }
  end;

var
  Frm_KJ_COST: TFrm_KJ_COST;

implementation

uses
  U_sysdb,JoeCommon,JoeMessages,cDateTime,U_Constant;


{$R *.dfm}

procedure TFrm_KJ_COST.Btn_QueryClick(Sender: TObject);
var
  KHBH,QSRQ,JZRQ,SCDH:string;
begin
  KHBH := CDS_M.Joe_GS('KHBH');
  if KHBH='' then ShowErrorBoxAbort(MSG_SelClient );
  QSRQ := JCT_SHRQ.GetText1(FormatDateTime('yyyy-mm-dd',FirstDayOfYear(Date())));
  JZRQ := JCT_SHRQ.GetText2(FormatDateTime('yyyy-mm-dd',LastDayOfYear(Date())));
  SCDH := JCE_SCDH.GetText();
  QueryParamsValue := Format('%s,%s,%s,%s',[KHBH,QSRQ,JZRQ,SCDH]);
  inherited;
end;

procedure TFrm_KJ_COST.CDS_D1AfterScroll(DataSet: TDataSet);
var
  ZBID:Integer;
begin
  inherited;
  ZBID := CDS_D1.Joe_GI('ZBID');
  CDS_D_D.JoeSetFilter(Format('ZBID=%D',[ZBID]));
end;

procedure TFrm_KJ_COST.CDS_D1CalcFields(DataSet: TDataSet);
begin
  inherited;
  with DataSet do begin
    Fieldbyname('C_XH').asinteger :=Recno;
    if FieldByName('SHSL').AsFloat>0 then
    FieldByName('C_CPDJ').AsFloat := Sysdb.PubF_Round(FieldByName('CPJE').AsFloat / FieldByName('SHSL').AsFloat,3);
    if FieldByName('BJSL').AsFloat >0 then
    FieldByName('C_BL').AsFloat := Sysdb.PubF_Round(FieldByName('SHSL').AsFloat / FieldByName('BJSL').AsFloat,5);
  end;
end;

procedure TFrm_KJ_COST.CDS_D_DCalcFields(DataSet: TDataSet);
begin
  inherited;
  with DataSet do begin
    Fieldbyname('C_XH').asinteger :=DataSet.Recno;
    if FieldByName('BJ_SL').AsFloat>0 then
    FieldByName('C_BJ_DJ').AsFloat :=  sysdb.PubF_Round(FieldByName('BJ_JE').AsFloat /FieldByName('BJ_SL').AsFloat ,5);
//    if FieldByName('CB_SL').AsFloat>0 then
//    FieldByName('C_CB_DJ').AsFloat :=  sysdb.PubF_Round(FieldByName('CB_JE').AsFloat /FieldByName('CB_SL').AsFloat ,5);
  end;
end;

procedure TFrm_KJ_COST.CDS_D_DNewRecord(DataSet: TDataSet);
begin
  inherited;
  with DataSet do begin
    FieldByName('ZBID').AsInteger := CDS_D1.Joe_GI('ZBID');   // D1ӱ D 
  end;
end;

procedure TFrm_KJ_COST.CDS_MAfterScroll(DataSet: TDataSet);
begin
  inherited;
  sysdb.PubP_ReadSpecifyDBGridLayOut(Self, G_Detail10, LayoutVer);
end;

procedure TFrm_KJ_COST.CDS_MNewRecord(DataSet: TDataSet);
begin
  inherited;
  with DataSet do begin
    FieldByName('DJRQ').AsDateTime := sysdb.PubF_GetSysDate(true);
    FieldByName('KHLX').AsInteger := 0;
  end;
end;

procedure TFrm_KJ_COST.DS_D1DataChange(Sender: TObject; Field: TField);
begin
  inherited;
  Sysdb.PubP_CacuSumMoney(CDS_D1,G_Detail1,'CPJE',1,ffNumber);
  Sysdb.PubP_CacuSumMoney(CDS_D1,G_Detail1,'SHSL',2,ffNumber);
end;

procedure TFrm_KJ_COST.DS_DDataChange(Sender: TObject; Field: TField);
begin
  inherited;
  Sysdb.PubP_CacuSumMoney(CDS_D,G_Detail,'CPJE',1,ffNumber);
  Sysdb.PubP_CacuSumMoney(CDS_D,G_Detail,'SHSL',2,ffNumber);
end;

procedure TFrm_KJ_COST.FormCreate(Sender: TObject);
begin
  inherited;
  G_Detail10.SearchPanel.Enabled := False;
  G_Detail10.JoeSetFieldDefaultLayout;
  JCT_SHRQ.DT1.Date :=  FirstDayOfYear(Date());
  JCT_SHRQ.DT2.Date :=  LastDayOfYear(Date());
  JCT_SHRQ.CHK.Checked := true;
end;

procedure TFrm_KJ_COST.FormShow(Sender: TObject);
begin
  inherited;
//  PriP_GetBJD;
end;

procedure TFrm_KJ_COST.G_Detail1CalcCellColors(Sender: TObject; Field: TField;
  State: TGridDrawState; Highlight: Boolean; AFont: TFont; ABrush: TBrush);
begin
  inherited;
//  if Field.FieldName='C_BL' then begin
    if CDS_D1.Joe_GF('C_BL')>1 then AFont.Color := clred;
//  end;

end;

procedure TFrm_KJ_COST.LCOM_BJ_DHBeforeDropDown(Sender: TObject);
begin
  PriP_GetBJD;
end;

procedure TFrm_KJ_COST.LCOM_BJ_DHCloseUp(Sender: TObject; LookupTable,
  FillTable: TDataSet; modified: Boolean);
begin
  inherited;
  if modified then begin
    FillTable.FieldByName('BJ_XH').AsInteger := LookupTable.FieldByName('BJ_XH').AsInteger;
    FillTable.FieldByName('BJSL').AsInteger := LookupTable.FieldByName('BJSL').AsInteger;
    FillTable.FieldByName('BJ_LX').AsInteger := LookupTable.FieldByName('LX').AsInteger;
    PriP_GetBJD_Detail;
  end;
end;

procedure TFrm_KJ_COST.LCOM_BJ_DHDropDown(Sender: TObject);
begin
  inherited;
  sysdb.PubF_SetDatasetDisplay(Qry_MSP_KJ_COST_GetBJD);    //Ч
end;

procedure TFrm_KJ_COST.N1Click(Sender: TObject);
var
  SCDH:string;
  SHSL:Integer;
  CPJE:Double;
begin
  inherited;
  if CDS_D.IsEmpty then ShowErrorBoxAbort('ͻϸûݣ');
  if not CDS_D1.IsEmpty then begin
    if ShowComfirmBox('ǰܱΪգǷ','ȷ','KJ_COST_DELETE_SHDHZ','','') then begin
      sysdb.PubP_DeleteDetail(CDS_D1);
      CDS_D_D.JoeCancelFiltered;
      sysdb.PubP_DeleteDetail(CDS_D_D);
      CDS_D_D.JoeSetFilter(Format('ZBID=%D',[CDS_D1.Joe_GI('ZBID')]));
    end;
  end;
//  CDS_D.Joe_P;
  CDS_D1.Joe_S_D;
  with CDS_D.Joe_P do begin
    Joe_S_D;
    First;
    while not eof do begin
      SCDH := Joe_GS('SCDH');
      SHSL := Joe_GI('SHSL');
      CPJE := sysdb.PubF_Round(Joe_GF('CPJE')*Joe_GF('HL'),3);
      if CDS_D1.Locate('SCDH',SCDH,[]) then begin
        CDS_D1.Joe_SI('SHSL',CDS_D1.Joe_GI('SHSL')+SHSL);
        CDS_D1.Joe_SF('CPJE',CDS_D1.Joe_GI('CPJE')+CPJE);
      end else begin
        CDS_D1.Append;
        CDS_D1.Joe_SS('SCDH',SCDH);
        CDS_D1.Joe_SI('SHSL',SHSL);
        CDS_D1.Joe_SF('CPJE',CPJE);
      end;  
      Next;
    end;
    Joe_S_E;
  end;
  CDS_D1.First;
  CDS_D1.Joe_S_E;

end;

procedure TFrm_KJ_COST.N3Click(Sender: TObject);
begin
  inherited;
  if ShowComfirmBox('ȷҪɾѡĿ', 'ȷ', 'KJ_COST_DELETE_SELETED', '', '') then begin
    sysdb.PubP_DeleteDetail(CDS_D_D);
    CDS_D1.Delete;
  end;
end;

procedure TFrm_KJ_COST.N4Click(Sender: TObject);
begin
  inherited;
  PriP_Calc_Detail;
end;

procedure TFrm_KJ_COST.N6Click(Sender: TObject);
begin
  inherited;
  PriP_GetBJD_Detail;
end;

procedure TFrm_KJ_COST.PM_Sub10Popup(Sender: TObject);
begin
  inherited;
  if not CDS_D.Active then abort;
  if not CDS_D1.Active then abort;
  if not CDS_D_D.Active then abort;
  if CDS_D_D.IsEmpty then abort;
  if not PubF_GetEditState then abort;
end;

procedure TFrm_KJ_COST.PM_SubD1Popup(Sender: TObject);
begin
  inherited;
  if not CDS_D.Active then abort;
  if not CDS_D1.Active then abort;
  if CDS_D.IsEmpty then abort;
  if not PubF_GetEditState then abort;

end;

procedure TFrm_KJ_COST.PriP_Calc_Detail;
begin
  with CDS_D_D do begin
    Joe_S_D.First;
    while not eof do begin
      Joe_SI('BJ_SL',CDS_D1.Joe_GI('BJSL'));
      Joe_SI('CB_SL',CDS_D1.Joe_GI('SHSL'));
      if Joe_GI('BJ_SL')>0 then
        Joe_Sf('CB_BL',Sysdb.PubF_Round(Joe_GI('CB_SL')/Joe_GI('BJ_SL'),5));
      Joe_Sf('CB_JE',Sysdb.PubF_Round(Joe_GF('CB_BL')*Joe_GF('BJ_JE'),4));
      Next;
    end;
    Joe_S_E.First;
  end;
end;

procedure TFrm_KJ_COST.PriP_GetBJD;
var
  KHBH,QSRQ:string;
begin
  KHBH := CDS_M.Joe_GS('KHBH');
  QSRQ := FormatDateTime('yyyy-mm-dd',Date - 2*365);
  Sysdb.PubP_OpenDataByAdo2(Qry_MSP_KJ_COST_GetBJD,17341,[KHBH,QSRQ]);
//  sysdb.PubF_SetDatasetDisplay(Qry_MSP_KJ_COST_GetBJD);    //ﲻɡ
end;

procedure TFrm_KJ_COST.PriP_GetBJD_Detail;
var
  LX,XH:string;
begin
  if not CDS_D_D.IsEmpty then
  if ShowComfirmBox('ݲΪգǷеݣ','ʾ','CONFIRM_DELETE_EXISTS_RECORD','','') then
    Sysdb.PubP_DeleteDetail(CDS_D_D)
  else Exit;

  LX := IntToStr(CDS_D1.Joe_GI('BJ_LX'));
  XH := IntToStr(CDS_D1.Joe_GI('BJ_XH'));
  Sysdb.PubP_OpenDataByAdo2(Qry_MSP_KJ_COST_GetBJD_Detail,17342,[LX,XH]);
  if not Qry_MSP_KJ_COST_GetBJD_Detail.IsEmpty then
    sysdb.PubP_CopyData_T2T(Qry_MSP_KJ_COST_GetBJD_Detail,CDS_D_D,
      'BJ_GXBH,BJ_GXLB,BJ_GXXM,BJ_JE',
      'BJ_GXBH,BJ_GXLB,BJ_GXXM,BJ_JE',true);
  PriP_Calc_Detail;
end;

end.
